//simple backdrop stage - floor with curved back wall
//m.miller 4.27.23

// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 10 } 
#include "sky.inc"
object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250) scale <-1,1,1> }


// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#declare C_white =          color rgb<1,1,1>  ;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_blue =           color rgb<0,.5,.9>  ;

#declare C_bg_gradient =
color_map {
    [ 0.0     C_gray60 ]  
    [ 0.40    C_white ]
    [ 0.50    C_horizon_blue ]
    [ 0.53    C_light_blue ]
    [ 1.0     C_blue ]
    }

#declare F_dull =
finish {
    ambient .2
    diffuse 1   
    phong .1
    phong_size 10  
}


#declare M_stage_gradient =
material {
    texture {
        pigment {
            gradient y
            color_map{C_bg_gradient }
        }
    finish {F_dull}    
    }
}

#declare stage = 
union {
    box {<-10.5,0,-10>,<10,-.01,10> }   
    difference {
        box {<-.5,0,0>,<.5,1,1> } 
        cylinder { <-.65,0,0>,<.65,0,0>, .5 translate <0,.5,0>}
    }                              
    material {M_stage_gradient scale <1,1.1,1> translate <0,-.1,0>}
    scale <2000,50,150>  translate <0,0,100> rotate <0,0,0>
    no_shadow
}